/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod;

import com.google.common.collect.ImmutableList;
import com.rwtema.monkmod.MonkMod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;

@SideOnly(value=Side.CLIENT)
public class MonkTextures {
    static final String MEDITATE = "monk:icon/meditate";
    public static KeyBinding blink;
    private static TextureMap map;

    public static void init() {
        blink = new KeyBinding("Blink", 33, "Monk Mod");
        blink.setKeyConflictContext(new IKeyConflictContext(){

            public boolean isActive() {
                return true;
            }

            public boolean conflicts(IKeyConflictContext other) {
                return this == other;
            }
        });
        ClientRegistry.registerKeyBinding((KeyBinding)blink);
        MinecraftForge.EVENT_BUS.register(MonkTextures.class);
        ModelResourceLocation modelResourceLocation = MonkTextures.getModelLocation();
        ModelLoader.setCustomModelResourceLocation((Item)MonkMod.ITEM_MONK_BASE, (int)0, (ModelResourceLocation)modelResourceLocation);
        ModelBakery.registerItemVariants((Item)MonkMod.ITEM_MONK_BASE, (ResourceLocation[])new ResourceLocation[]{modelResourceLocation});
        ModelLoader.setCustomMeshDefinition((Item)MonkMod.ITEM_MONK_BASE, stack -> modelResourceLocation);
    }

    @Nonnull
    private static ModelResourceLocation getModelLocation() {
        return new ModelResourceLocation(((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).toString(), "inventory");
    }

    @SubscribeEvent
    public static void registerTexture(@Nonnull TextureStitchEvent.Pre event) {
        map = event.getMap();
        ModContainer containerFor = FMLCommonHandler.instance().findContainerFor((Object)MonkMod.instance);
        CraftingHelper.findFiles((ModContainer)containerFor, (String)"assets/monk/textures/icon", null, (root, file) -> {
            if ("png".equals(FilenameUtils.getExtension((String)file.toString()))) {
                String baseName = FilenameUtils.getBaseName((String)file.toString());
                map.func_174942_a(new ResourceLocation("monk", "icon/" + baseName));
            }
            return true;
        }, (boolean)true, (boolean)true);
    }

    @SubscribeEvent
    public static void registerModels(@Nonnull ModelBakeEvent event) {
        ModelResourceLocation modelResourceLocation = MonkTextures.getModelLocation();
        event.getModelRegistry().func_82595_a((Object)modelResourceLocation, (Object)new Model());
    }

    private static class MyIBakedModel
    implements IBakedModel {
        @Nonnull
        final TextureAtlasSprite sprite;
        @Nonnull
        final List<BakedQuad> quads;

        private MyIBakedModel(@Nonnull TextureAtlasSprite sprite) {
            this.sprite = sprite;
            this.quads = ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)sprite, (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(TRSRTransformation.identity()));
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.quads;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.sprite;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }

    private static class Model
    implements IBakedModel {
        @Nonnull
        final Map<String, IBakedModel> modelMap = new HashMap<String, IBakedModel>();

        private Model() {
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.getDefaultTex().func_188616_a(state, side, rand);
        }

        private IBakedModel getDefaultTex() {
            return this.getOrLoadModel(MonkTextures.MEDITATE);
        }

        public boolean func_177555_b() {
            return this.getDefaultTex().func_177555_b();
        }

        public boolean func_177556_c() {
            return this.getDefaultTex().func_177555_b();
        }

        public boolean func_188618_c() {
            return this.getDefaultTex().func_188618_c();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.getDefaultTex().func_177554_e();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return new ItemOverrideList((List)ImmutableList.of()){

                @Nonnull
                public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    NBTTagCompound tagCompound = stack.func_77978_p();
                    String icon = tagCompound != null ? tagCompound.func_74779_i("icon") : "";
                    return this.getOrLoadModel(icon);
                }
            };
        }

        protected IBakedModel getOrLoadModel(String icon) {
            return this.modelMap.computeIfAbsent(icon, s -> new MyIBakedModel(map.func_110572_b(s)));
        }
    }
}

